# COUNTERFACTUAL DENSITY ESTIMATION USING KERNEL STEIN DISCREPANCIES

Implementation of the DR-MKSD estimator. 

## Structure

The repository contains 
- Python scripts, which implement the DR-MKSD and various experimental settings. 
- Python notebooks, which make use of the scripts to run the experiments and plot the results. 
- Data folder, which stores the outputs of the experiments run.

## DRKSD 

- **loss.py** contains the implementation of weighted KSD. 
- **debiaser.py** contains the function that outputs the weights given by DR-MKSD used in weighted KSD.
- **utils.py** finds the minimizer of the loss function.
- **distributions.py** samples observations for different experiments. 
- **learners.py** contains the score function for the different experiments. 
- **experiments.py** sets up the different experiments.
- **MNIST_nn** trains the neural network and finds the lower dimensional representations for the MNIST example. 

## Notebooks

- **main.py** runs the experiments. 
- **plots.ipynb** generates the plots for most of the experiments.
- **plot_mnist.ipynb** generates the plots for the MNIST example. 

## Data
Contains the data obtained when running the experiments. Data for the MNIST experiment was not uploaded for size constraints. It suffices to run **train_mnist_nn.py** followed by **eval_mnist_nn.py** before using **plot_mnist.ipynb**.