import pandas as pd
import glob
from sklearn.metrics import precision_score, recall_score, accuracy_score
import numpy as np
import os

levels = ["Child", "Teen", "College Student", "Grad Student", "Expert"]

model_name = "qwen-plus"
print(model_name)


for role in ["ask", "answer"]:
    file_path = f"./results/classification2/{model_name}/{role}"
    csv_files = glob.glob(file_path + "/*.csv")
    csv_files = [file for file in csv_files if not os.path.basename(file).startswith("summary")]
    dataframes = [pd.read_csv(file) for file in csv_files]
    print("*"*10)

    summary = pd.DataFrame(columns=["level1", "level2", "accuracy", "num_samples", "total_cost"])
    for level1 in levels:
        for level2 in levels:
            if level1 == level2:
                continue
            summary.loc[len(summary)] = [level1, level2, 0.0, 0, 0.0]
    summary.loc[len(summary)] = ["total", "total", 0.0, 0, 0.0]

    for df in dataframes:
        for i in range(len(df)):
            level1 = df.loc[i, "level1"]
            level2 = df.loc[i, "level2"]

            old_num_samples = summary[(summary["level1"] == level1) & (summary["level2"] == level2)]["num_samples"].values[0]
            old_accuracy = summary[(summary["level1"] == level1) & (summary["level2"] == level2)]["accuracy"].values[0]

            summary.loc[(summary["level1"] == level1) & (summary["level2"] == level2), "accuracy"] = (old_accuracy*old_num_samples + df.loc[i, "accuracy"]) / (old_num_samples + 1)
            summary.loc[(summary["level1"] == level1) & (summary["level2"] == level2), "num_samples"] += 1
            summary.loc[(summary["level1"] == level1) & (summary["level2"] == level2), "total_cost"] += df.loc[i, "cost"]

            summary.loc[summary["level1"] == "total", "num_samples"] = summary.loc[summary["level1"] != "total", "num_samples"].sum()
            summary.loc[summary["level1"] == "total", "total_cost"] = summary.loc[summary["level1"] != "total", "total_cost"].sum()
            acc = 0
            for i in range(len(summary)):
                if summary.loc[i, "level1"] != "total":
                    acc += summary.loc[i, "accuracy"] * summary.loc[i, "num_samples"]
            summary.loc[len(summary)-1, "accuracy"] = acc / summary.loc[len(summary)-1, "num_samples"]

    summary.to_csv(f"./summary_classification2_{role}_{model_name}.csv")

