#!/usr/bin/env bash

cd ../src_classification

export dataset=${your_dict}
export dropout_ratio=0.0
export epochs=100
export aug_strength=0.1

export mode_list=(fragcl)

for mode in "${mode_list[@]}"; do
     export folder="$mode"/"$dataset"/epochs_"$epochs"_"$dropout_ratio"_aug_"$aug_strength"
     echo "$folder"

     mkdir -p ../output/"$folder"

     export output_file=../output/"$folder"/pretraining.out
     export output_model_dir=../output/"$folder"/pretraining
     
     
     if [[ ! -f "$output_file" ]]; then
          echo "$folder" undone

          bash run_pretrain_"$mode".sh \
          --epochs="$epochs" \
          --dataset="$dataset" \
          --batch_size=256 \
          --dropout_ratio="$dropout_ratio" --num_workers=8 \
          --output_model_dir="$output_model_dir" \
	  --aug_mode="choosetwo" \
	  --choose=0 \
	  --gnn_type='gin' \
	  --aug_strength="$aug_strength" \
	  --normalize
     fi
done
