_base_ = [
    '../../_base_/models/semi_faster_rcnn_r101_fpn_ddt.py',
    '../../_base_/da_setting/semi_e2e_20k_0.1backbone.py',
    '../../_base_/datasets/sim10k_to_bdd100k/semi_sim10k_to_bdd100k.py'
]

detector = _base_.model
detector.data_preprocessor = dict(
    type='DetDataPreprocessor',
    mean=[123.675, 116.28, 103.53],
    std=[58.395, 57.12, 57.375],
    bgr_to_rgb=True,
    pad_size_divisor=64)

detector.detector.roi_head.bbox_head.num_classes = 1
detector.dift_model.config = 'DA/Ours/sim10k_to_bdd100k/diffusion_faster-rcnn_fpn_sim10k_to_bdd100k_source.py'
detector.dift_model.pretrained_model = '.pth path'

model = dict(
    _delete_=True,
    type='DomainAdaptationDetector',
    detector=detector,
    data_preprocessor=dict(
        type='MultiBranchDataPreprocessor',
        data_preprocessor=detector.data_preprocessor),
    train_cfg=dict(
        detector_cfg=dict(type='SemiBaseDift', burn_up_iters=_base_.burn_up_iters),  # []
    )
)
optim_wrapper = dict(clip_grad=dict(max_norm=35, norm_type=2))