import torch
import torch.nn as nn
import torch.nn.functional as F

configs = [{'GAE': # 0 for the GSQAS encoding scheme + GSQAS model
                {'activation_adj': torch.sigmoid, 'activation_ops': torch.softmax, 'activation_ops_qubits': torch.sigmoid, 'adj_hidden_dim': 128, 'ops_hidden_dim': 128},
            'loss':
                {'loss_ops': nn.BCELoss(), 'loss_adj': nn.BCELoss()},
            'prep':
                {'method': 5, 'lbd': 1.0}
            },
           {'GAE': # 1 for the improved GSQAS encoding scheme + QuantumArch2Vec
                {'activation_adj': torch.relu, 'activation_ops': torch.softmax, 'activation_ops_qubits': torch.tanh, 'adj_hidden_dim': 128, 'ops_hidden_dim': 128},
            'loss':
                {'loss_ops': F.mse_loss, 'loss_adj': F.mse_loss},
            'prep':
                {'method': 5, 'lbd': 1.0}
            },
           {'GAE': # 2 for the improved GSQAS encoding scheme with degree + QuantumArch2Vec with degree consistency loss
                {'activation_adj': torch.relu, 'activation_ops': torch.softmax, 'activation_ops_qubits': torch.tanh, 'adj_hidden_dim': 128, 'ops_hidden_dim': 128},
            'loss':
                {'loss_ops': F.mse_loss, 'loss_adj': F.mse_loss},
            'prep':
                {'method': 5, 'lbd': 1.0}
            },
           ]