#!/usr/bin/env bash

python search_methods/reinforce_fidelity_8_qubits.py --emb_path fidelity-model-circuits_8_qubits_gsqas.pt --model_path model-circuits_8_qubits_gsqas.pt \
        --cfg 0 --model_flag "gsqas" --saved_fidelity --input_dim 21 --dim 16 --num_sample 100000
python utils/embedding_merge.py --app fidelity --full_emb_path pretrained\\dim-16\\fidelity-model-circuits_8_qubits_gsqas_full_embedding.pt --emb_path pretrained\\dim-16\\fidelity-model-circuits_8_qubits_quantum_arch2vec.pt \
        --save_path pretrained\\dim-16\\fidelity-model-circuits_8_qubits_quantum_arch2vec_full_embedding.pt
python utils/embedding_merge.py --app fidelity --full_emb_path pretrained\\dim-16\\fidelity-model-circuits_8_qubits_gsqas_full_embedding.pt --emb_path pretrained\\dim-16\\fidelity-model-circuits_8_qubits_quantum_arch2vec_with_degree.pt \
        --save_path pretrained\\dim-16\\fidelity-model-circuits_8_qubits_quantum_arch2vec_with_degree_full_embedding.pt

python search_methods/reinforce_vqe_8_qubits.py --emb_path vqe-model-circuits_8_qubits_gsqas.pt --model_path model-circuits_8_qubits_gsqas.pt \
        --cfg 0 --model_flag "gsqas" --saved_vqe --input_dim 21 --dim 16 --num_sample 100000
python utils/embedding_merge.py --app vqe --full_emb_path pretrained\\dim-16\\vqe-model-circuits_8_qubits_gsqas_full_embedding.pt --emb_path pretrained\\dim-16\\vqe-model-circuits_8_qubits_quantum_arch2vec.pt \
        --save_path pretrained\\dim-16\\vqe-model-circuits_8_qubits_quantum_arch2vec_full_embedding.pt
python utils/embedding_merge.py --app vqe --full_emb_path pretrained\\dim-16\\vqe-model-circuits_8_qubits_gsqas_full_embedding.pt --emb_path pretrained\\dim-16\\vqe-model-circuits_8_qubits_quantum_arch2vec_with_degree.pt \
        --save_path pretrained\\dim-16\\vqe-model-circuits_8_qubits_quantum_arch2vec_with_degree_full_embedding.pt

python search_methods/reinforce_maxcut_8_qubits.py --emb_path maxcut-model-circuits_8_qubits_gsqas.pt --model_path model-circuits_8_qubits_gsqas.pt \
        --cfg 0 --model_flag "gsqas" --saved_maxcut --input_dim 21 --dim 16 --num_sample 100000
python utils/embedding_merge.py --app maxcut --full_emb_path pretrained\\dim-16\\maxcut-model-circuits_8_qubits_gsqas_full_embedding.pt --emb_path pretrained\\dim-16\\maxcut-model-circuits_8_qubits_quantum_arch2vec.pt \
        --save_path pretrained\\dim-16\\maxcut-model-circuits_8_qubits_quantum_arch2vec_full_embedding.pt
python utils/embedding_merge.py --app maxcut --full_emb_path pretrained\\dim-16\\maxcut-model-circuits_8_qubits_gsqas_full_embedding.pt --emb_path pretrained\\dim-16\\maxcut-model-circuits_8_qubits_quantum_arch2vec_with_degree.pt \
        --save_path pretrained\\dim-16\\maxcut-model-circuits_8_qubits_quantum_arch2vec_with_degree_full_embedding.pt