#!/bin/bash

#SBATCH --job-name=cocoop_test
#SBATCH --gpus=a100_80gb:1
#SBATCH --time=12:00:00
#SBATCH --mem-per-cpu=50G

module load gcc/8.2.0 python_gpu/3.9.9

# custom config
DATA=./ov-seg-clip/open_clip_training/openclip_data
TRAINER=CoCoOp

DATASET=scannetpp_val
SEED=1

CFG=vit_l14_c4_ep5_batch4_ctxv1
SHOTS=0


DIR=output/evaluation/${TRAINER}/${CFG}_${SHOTS}shots/${DATASET}/seed${SEED}

source ./maple/bin/activate

if [ -d "$DIR" ]; then
    echo "Results are available in ${DIR}. Still do not this job"

    python train.py \
    --root ${DATA} \
    --seed ${SEED} \
    --trainer ${TRAINER} \
    --dataset-config-file configs/datasets/${DATASET}.yaml \
    --config-file configs/trainers/${TRAINER}/${CFG}.yaml \
    --output-dir ${DIR} \
    --model-dir output/scannetpp/${TRAINER}/${CFG}_${SHOTS}shots/seed${SEED} \
    --load-epoch 5 \
    --eval-only
else
    echo "Run this job and save the output to ${DIR}"

    python train.py \
    --root ${DATA} \
    --seed ${SEED} \
    --trainer ${TRAINER} \
    --dataset-config-file configs/datasets/${DATASET}.yaml \
    --config-file configs/trainers/${TRAINER}/${CFG}.yaml \
    --output-dir ${DIR} \
    --model-dir output/imagenet/${TRAINER}/${CFG}_${SHOTS}shots/seed${SEED} \
    --load-epoch 2 \
    --eval-only
fi