#!/bin/bash

#SBATCH --job-name=maple_test
#SBATCH --gpus=quadro_rtx_6000:1
#SBATCH --time=12:00:00
#SBATCH --mem-per-cpu=50G

module load gcc/8.2.0 python_gpu/3.9.9

# custom config
DATA="./ov-seg-clip/open_clip_training/openclip_data"
TRAINER=MaPLe

DATASET=scannetpp_val
SEED=1

CFG=vit_l14_c2_ep5_batch8_2ctx_cross_datasets_depth24
SHOTS=0

source ./maple/bin/activate

DIR=output/evaluation/${TRAINER}/${CFG}_${SHOTS}shots/${DATASET}/seed${SEED}
echo "Run this job and save the output to ${DIR}"

python train.py \
    --root ${DATA} \
    --seed ${SEED} \
    --trainer ${TRAINER} \
    --dataset-config-file configs/datasets/${DATASET}.yaml \
    --config-file configs/trainers/${TRAINER}/${CFG}.yaml \
    --output-dir ${DIR} \
    --model-dir output/scannetpp/${TRAINER}/${CFG}_${SHOTS}shots/seed${SEED} \
    --load-epoch 5 \
    --eval-only