#!/bin/bash

#SBATCH --job-name=maple_train
#SBATCH --gpus=quadro_rtx_6000:1
#SBATCH --time=12:00:00
#SBATCH --mem-per-cpu=50G

module load gcc/8.2.0 python_gpu/3.9.9

# custom config
DATA="./ov-seg-clip/open_clip_training/openclip_data"
TRAINER=MaPLe

DATASET=scannetpp
SEED=12

CFG=vit_b16_c2_ep5_batch8_2ctx_cross_datasets
SHOTS=0

source ./maple/bin/activate

DIR=output/${DATASET}/${TRAINER}/${CFG}_${SHOTS}shots/seed${SEED}
if [ -d "$DIR" ]; then
    echo "Results are available in ${DIR}. But still running again"

    python train.py \
    --root ${DATA} \
    --seed ${SEED} \
    --trainer ${TRAINER} \
    --dataset-config-file configs/datasets/${DATASET}.yaml \
    --config-file configs/trainers/${TRAINER}/${CFG}.yaml \
    --output-dir ${DIR} \
    DATASET.NUM_SHOTS ${SHOTS}
else
    echo "Run this job and save the output to ${DIR}"

    python train.py \
    --root ${DATA} \
    --seed ${SEED} \
    --trainer ${TRAINER} \
    --dataset-config-file configs/datasets/${DATASET}.yaml \
    --config-file configs/trainers/${TRAINER}/${CFG}.yaml \
    --output-dir ${DIR} \
    DATASET.NUM_SHOTS ${SHOTS}
fi