#!/bin/bash

#SBATCH --job-name=ivlp_test
#SBATCH --gpus=1
#SBATCH --gres=gpumem:20g
#SBATCH --time=04:00:00
#SBATCH --ntasks=4
#SBATCH --mem-per-cpu=50G

module load gcc/8.2.0 python_gpu/3.9.9

# custom config
DATA=./ov-seg-clip/open_clip_training/openclip_data
TRAINER=OpenDAS

DATASET=scannetpp_val
SEED=429

CFG=vit_l14_c2_ep10_batch16_2+2ctx_d24_use_both_losses
SHOTS=0

source ./maple/bin/activate

# DIR=output/evaluation/${TRAINER}/${CFG}_${SHOTS}shots/${DATASET}/seed${SEED}
DIR=output/evaluation/${TRAINER}/vit_l14_c2_ep10_batch16_2+2ctx_d24_use_both_losses_0shots/${DATASET}/seed${SEED}

echo "Run this job and save the output to ${DIR}"

python train.py \
    --root ${DATA} \
    --seed ${SEED} \
    --trainer ${TRAINER} \
    --dataset-config-file configs/datasets/${DATASET}.yaml \
    --config-file configs/trainers/${TRAINER}/${CFG}.yaml \
    --output-dir ${DIR} \
    --model-dir output/scannetpp_similar_negative_v2/${TRAINER}/${CFG}_${SHOTS}shots/seed${SEED} \
    --load-epoch 8 \
    --eval-only