#!/bin/bash

#SBATCH --job-name=rpo_test
#SBATCH --gpus=quadro_rtx_6000:1
#SBATCH --time=02:00:00
#SBATCH --mem-per-cpu=50G

module load gcc/8.2.0 python_gpu/3.9.9

# custom config
DATA="./ov-seg-clip/open_clip_training/openclip_data"
TRAINER=RPO

DATASET=kitti360
SEED=1

CFG=main_vitl14
SHOTS=0

LOADEP=5
SUB=all


COMMON_DIR=shots_${SHOTS}/${TRAINER}/${CFG}/seed${SEED}
MODEL_DIR=output/rpo/base2new/train_base/kitti360/${COMMON_DIR}
DIR=output/rpo/base2new/test_${SUB}/${DATASET}/${COMMON_DIR}

source ./maple/bin/activate

python train.py \
    --root ${DATA} \
    --seed ${SEED} \
    --trainer ${TRAINER} \
    --dataset-config-file configs/datasets/${DATASET}.yaml \
    --config-file configs/trainers/${TRAINER}/${CFG}.yaml \
    --output-dir ${DIR} \
    --model-dir ${MODEL_DIR} \
    --load-epoch ${LOADEP} \
    --eval-only \
    DATASET.NUM_SHOTS ${SHOTS} \
    DATASET.SUBSAMPLE_CLASSES ${SUB}
