#!/bin/bash

#SBATCH --job-name=rpo_train
#SBATCH --gpus=a100_80gb:1
#SBATCH --time=12:00:00
#SBATCH --mem-per-cpu=50G

module load gcc/8.2.0 python_gpu/3.9.9

# custom config
DATA="./ov-seg-clip/open_clip_training/openclip_data"
TRAINER=RPO

DATASET=scannetpp
SEED=12

CFG=main_vitl14_b8
SHOTS=0

source ./maple/bin/activate

DIR=output/rpo/domain/${DATASET}/${TRAINER}/${CFG}_${SHOTS}shots/seed${SEED}
if [ -d "$DIR" ]; then
    echo "Oops! The results exist at ${DIR} (so skip this job)"
else
    CUDA_VISIBLE_DEVICES=${GPU} python train.py \
    --root ${DATA} \
    --seed ${SEED} \
    --trainer ${TRAINER} \
    --dataset-config-file configs/datasets/${DATASET}.yaml \
    --config-file configs/trainers/${TRAINER}/${CFG}.yaml \
    --output-dir ${DIR} \
    DATASET.NUM_SHOTS ${SHOTS}
fi