#!/bin/bash

#SBATCH --job-name=vpt_train
#SBATCH --gpus=quadro_rtx_6000:1
#SBATCH --time=24:00:00
#SBATCH --mem-per-cpu=50G

module load gcc/8.2.0 python_gpu/3.9.9

# custom config
DATA="./ov-seg-clip/open_clip_training/openclip_data"
TRAINER=VPT

DATASET=ade20k_150
SEED=428

CFG=vit_l14_c2_ep5_batch32_4_depth_6
SHOTS=0

source ./maple/bin/activate

DIR=output/${DATASET}/${TRAINER}/${CFG}_${SHOTS}shots/seed${SEED}
if [ -d "$DIR" ]; then
    echo "Results are available in ${DIR}. But still running again"
fi

echo "Run this job and save the output to ${DIR}"

python train.py \
--root ${DATA} \
--seed ${SEED} \
--trainer ${TRAINER} \
--dataset-config-file configs/datasets/${DATASET}.yaml \
--config-file configs/trainers/${TRAINER}/${CFG}.yaml \
--output-dir ${DIR} \
DATASET.NUM_SHOTS ${SHOTS}
