## Getting started with OVSeg+OpenDAS

For the demo and visualizations, you should download the original OVSeg: (Swin-Base + CLIP-ViT-L/14) [ovseg_swinbase_vitL14_ft_mpt.pth](https://drive.google.com/file/d/1cn-ohxgXDrDfkzC1QdO-fi8IjbjXmgKy/view?usp=sharing) (md5: <tt>526080</tt>).


### Visualization of Results with GT Masks

- Test on sample image
  ```bash
  bash demo.sh
  ```

### Visualization of Results with MaskFormer Masks

- Test on sample image
  ```bash
  bash demo_maskformer.sh
  ```

### Evaluation with pre-trained weights

Following the instructions from [open clip training](./open_clip_training/README.md), you can obtain the weights for OpenDAS (md5: <tt>526080</tt>).
Also please set the config in [config.py](./open_vocab_seg/config.py) for the respective multi-modal prompt tuning method, you would like to try.

- Test on ADE20K-150 and ADE-847
  ```bash
  python train_net.py --num-gpu 8 --eval-only --config-file configs/ovseg_swinB_vitL_bs32_120k.yaml MODEL.WEIGHTS #PATH_of_OpenDAS.pth DATASETS.TEST \(\"ade20k_sem_seg_val\",\"ade20k_full_sem_seg_val\"\) 
  ```