import os
from pathlib import Path
import glob
import shutil
from tqdm import tqdm

KITTI_DIR = Path("./data/kitti-360")
MAIN_KITTI_DIR = Path("./data/kitti-360/")
    

def _get_images_labels(split_name):
    filepath = MAIN_KITTI_DIR / "data_2d_semantics" / "train"
    with open(os.path.join(filepath, f"2013_05_28_drive_{split_name}_frames.txt")) as f:
        lines = f.readlines()
        images = []
        labels = []
        for line in lines:
            image, gt = line.strip().split(" ")
            images.append(image)
            labels.append(gt)
    
    return images, labels
    
def make_clean_dir(dir_name):
    if os.path.exists(dir_name):
        files = glob.glob(str(dir_name / "*"))
        for f in files:
            os.remove(f)
    else:
        os.makedirs(dir_name)

def prepare_kitti():
    root = KITTI_DIR
    main_root = MAIN_KITTI_DIR
    for split_name in ["train", "val"]:
        print(f"Processing {split_name} split")
        out_dir = root / split_name

        out_image_dir = out_dir / "images"
        out_gt_dir = out_dir / "semantics"

        images, labels = _get_images_labels(split_name)

        make_clean_dir(out_image_dir)
        make_clean_dir(out_gt_dir)
        
        for image, label in tqdm(zip(images, labels)):
            img_dir_split = image.split('/')
            new_filename = f"{img_dir_split[1]}_{img_dir_split[2]}_{img_dir_split[-1]}"
            shutil.copy2(main_root / image, out_image_dir / new_filename)
            
            lbl_dir_split = label.split('/')
            new_filename = f"{img_dir_split[1]}_{img_dir_split[2]}_{lbl_dir_split[-1]}"
            shutil.copy2(main_root / label, out_gt_dir / new_filename)

prepare_kitti()
