import os
from pathlib import Path
import glob
import shutil
from tqdm import tqdm

SCANNETPP_DIR = Path("./data/scannet++/")
MAIN_SCANNETPP_DIR = Path("./scannet++/data")

def _get_scenes(split_name):
    scenes_filepath = SCANNETPP_DIR / f"scenes_{split_name}.txt"
    with open(scenes_filepath) as f:
        lines = f.readlines()
        return [line.strip() for line in lines]
    
def make_clean_dir(dir_name):
    if os.path.exists(dir_name):
        files = glob.glob(str(dir_name / "*"))
        for f in files:
            os.remove(f)
    else:
        os.makedirs(dir_name)

def prepare_scannetpp():
    root = SCANNETPP_DIR
    main_root = MAIN_SCANNETPP_DIR
    for split_name in ["train", "val"]:
        print(f"Processing {split_name} split")
        scene_ids = _get_scenes(split_name)
        out_dir = root / split_name

        out_image_dir = out_dir / "iphone" / "rgb"
        out_gt_dir = out_dir / "iphone" / "render_semantic_id"

        make_clean_dir(out_image_dir)
        make_clean_dir(out_gt_dir)
        
        for scene_id in tqdm(scene_ids):
            image_dir = main_root / scene_id / "iphone" / "rgb"
            gt_dir = root / scene_id / "iphone" / "render_semantic_id"

            for file in glob.glob(str(image_dir / "*0.jpg")):
                new_filename = f"{scene_id}_{file.split('/')[-1]}"
                shutil.copy2(file, out_image_dir / new_filename)
            
            for file in glob.glob(str(gt_dir / "*.png")):
                new_filename = f"{scene_id}_{file.split('/')[-1]}"
                shutil.copy2(file, out_gt_dir / new_filename)

prepare_scannetpp()
