#!/bin/bash

#SBATCH --job-name=background
#SBATCH --gpus=quadro_rtx_6000:2
#SBATCH --time=48:00:00
#SBATCH --mem-per-cpu=50G

module load gcc/8.2.0 python_gpu/3.9.9

torchrun --nproc_per_node 2 -m training.main \
    --batch-size 16 \
    --precision amp \
    --workers 4 \
    --model  ViT-L-14 \
    --lock-text \
    --zeroshot-frequency 1 \
    --save-frequency 5 \
    --epoch 5 \
    --pretrained  ./logs/2023_11_22-13_24_47-model_ViT-L-14-lr_5e-06-b_32-j_4-p_amp\
    --ade-val ../openclip_data/ade20k_150/ade_gt_150cls_val

# --train-data ../openclip_data/ade20k_150/ade_gt_150cls_v3.csv \
#     --train-num-samples 141609 \
#     --lr 0.000005 \
#     --warmup 100 \
#     --force-quick-gelu \
#     --dataset-type csv \
#    --pretrained  openai \