# Run OpenMask3D + OpenDAS on Euler

**Use OpenMask3D with Scannet++**

    SCENE_LIST: set the list of scenes to run the model.
    openmask3d.frequency: frame sampling frequency for all experiments (default: 20)

**Setup Euler:**

Given that you followed the instructions [here](openmask3d/README.md).

```bash
cd <REPO_DIR>
module load gcc/8.2.0 python_gpu/3.8.5 r/4.0.2 git-lfs/2.3.0 2>/dev/null cmake/3.9.4 qt/5.10.0 boost/1.74.0 eth_proxy npm/6.14.9 open3d openblas cuda/11.3.1 cudnn/8.2.1.32
source myenv/openmask/bin/activate
cd scannetpp
```

**Prepare instance_gts:**

1. First prepare training data:

```bash
python -m semantic.prep.prepare_training_data semantic/configs/prepare_training_data.yml
```

1. Once you have the pth files under: <PTH_DIR>. Then,

```bash
python -m semantic.prep.prepare_semantic_gt semantic/configs/prepare_semantic_gt.yml
```

**Run scannetpp_preprocessing for validation npy files:**

```bash
cd ../openmask3d/openmask3d/class_agnostic_mask_computation/python -m datasets.preprocessing.scannetpp_preprocessing preprocess # give the **right scene list**
```

**Copy** the content of: <DATA_DIR>/instance_gts into

- /scannetpp/GT_INST_100

**Run class-agnostic mask predictions:**

- cd ../../
- bash run_openmask3d_scannetpp_eval.sh 
- Get masks dir: <MASK_DIR>

**Run mask feature computation:**

- Set mask prediction and output dir
- Set USE_OPENDAS=true
- Note that openmask3d.frequency=20
- To submit the jobs in Euler:

```bash
bash run_get_features_opendas.sh
```

OR

```bash
bash submit_sbatches_mask3d_scannet.sh
```

**RUN predictions** eval_open_vocab_scannetpp_val_offices.py**:**

- **Set** USE_OPENDAS=True
    - **Set** mask_features_dir > <RES_DIR>/${SCENE_NAME}/masks_results
    - **Set** pred_export_dir****
- **Set** pred_mask_dir from Step 1

```bash
cd ../scannetpp
python eval_open_vocab_scannetpp_val_offices.py
```

**RUN evaluation**

- Set USE_OPENDAS=True
```bash
python -m semantic.eval.eval_openmask3d_scannetpp_val_offices_head_tail_opendas
```