#!/bin/bash

#SBATCH --job-name=openmask3d
#SBATCH --gpus=1
#SBATCH --gres=gpumem:40g
#SBATCH --time=04:00:00
#SBATCH --ntasks=2
#SBATCH --mem-per-cpu=50G

export OMP_NUM_THREADS=3  # speeds up MinkowskiEngine
set -e

# RUN OPENMASK3D FOR A SINGLE SCENE
# This script performs the following:
# 1. Compute class agnostic masks and save them
# 2. Compute mask features for each mask and save them

# --------
# NOTE: SET THESE PARAMETERS BASED ON YOUR SCENE!
# data paths
echo "In run ONE mask3d - ${SCENE_NAME}"

SCENE_DIR="./scannet++/data/${SCENE_NAME}"
# SCENE_POSE_DIR="${SCENE_DIR}/aligned_pose"
SCENE_POSES_INTRINSIC_PATH="${SCENE_DIR}/iphone/pose_intrinsic_imu.json"
SCENE_INTRINSIC_RESOLUTION="[1440,1920]" # change if your intrinsics are based on another resolution
SCENE_PLY_PATH="${SCENE_DIR}/scans/mesh_aligned_0.05.ply"
SCENE_COLOR_IMG_DIR="${SCENE_DIR}/iphone/rgb"
SCENE_DEPTH_IMG_DIR="${SCENE_DIR}/iphone/depth"
IMG_EXTENSION=".jpg"
DEPTH_EXTENSION=".png"
DEPTH_SCALE=1000
NUM_OF_LEVELS=3
# model ckpt paths


SAM_CKPT_PATH="./openmask3d/resources/sam_vit_h_4b8939.pth"
# output directories to save masks and mask features
EXPERIMENT_NAME="scannetpp_office"
OUTPUT_DIRECTORY="./scannetpp_masks_and_results_with_overridden_clip_num_levels_${NUM_OF_LEVELS}/${SCENE_NAME}/masks_results"
OUTPUT_FOLDER_DIRECTORY="${OUTPUT_DIRECTORY}"
SAVE_VISUALIZATIONS=true #if set to true, saves pyviz3d visualizations
SAVE_CROPS=true 
# gpu optimization
OPTIMIZE_GPU_USAGE=true
# DONT use opendas
USE_OPENDAS=false

cd openmask3d

# get the path of the saved masks
SCENE_MASK_PATH="./openmask3d/output/2024-03-23-15-14-28-scannetpp_office/masks/${SCENE_NAME}_masks.pt"

echo "[INFO] Masks will be read from ${SCENE_MASK_PATH}."

# 2. Compute mask features for each mask and save them
echo "[INFO] Computing mask features..."

python compute_features_single_scene.py \
    data.masks.masks_path=${SCENE_MASK_PATH} \
    data.camera.poses_intrinsic_path=${SCENE_POSES_INTRINSIC_PATH} \
    data.camera.intrinsic_resolution=${SCENE_INTRINSIC_RESOLUTION} \
    data.depths.depths_path=${SCENE_DEPTH_IMG_DIR} \
    data.depths.depth_scale=${DEPTH_SCALE} \
    data.images.images_path=${SCENE_COLOR_IMG_DIR} \
    data.point_cloud_path=${SCENE_PLY_PATH} \
    output.output_directory=${OUTPUT_FOLDER_DIRECTORY} \
    output.save_crops=${SAVE_CROPS} \
    hydra.run.dir="${OUTPUT_FOLDER_DIRECTORY}/hydra_outputs/mask_features_computation" \
    external.sam_checkpoint=${SAM_CKPT_PATH} \
    external.clip_model="ViT-L/14" \
    external.use_opendas=${USE_OPENDAS} \
    gpu.optimize_gpu_usage=${OPTIMIZE_GPU_USAGE} \
    openmask3d.frequency=60 \
    openmask3d.num_of_levels=${NUM_OF_LEVELS}
echo "[INFO] Feature computation done!"
