import torch
import clip
from sklearn.manifold import TSNE
import matplotlib.pyplot as plt
from adjustText import adjust_text  # Import the adjustText library

def generate_text_embeddings(texts):
    # Load the model
    device = "cuda" if torch.cuda.is_available() else "cpu"
    model, preprocess = clip.load("ViT-B/32", device=device)
    
    # Prepare the texts
    text_tokens = clip.tokenize(texts).to(device)
    
    # Generate embeddings
    with torch.no_grad():
        text_embeddings = model.encode_text(text_tokens)
    
    return text_embeddings.cpu().numpy()

def tsne_visualization(embeddings, labels):
    # Perform t-SNE
    tsne = TSNE(n_components=2, random_state=42)
    tsne_results = tsne.fit_transform(embeddings)
    
    # Plotting
    plt.figure(figsize=(10, 6))
    texts = []
    for i, label in enumerate(labels):
        plt.scatter(tsne_results[i, 0], tsne_results[i, 1])
        texts.append(plt.text(tsne_results[i, 0], tsne_results[i, 1], label,
                     ha='center', va='center'))
    
    adjust_text(texts, arrowprops=dict(arrowstyle='->', color='red'))

    plt.xlabel("t-SNE feature 0")
    plt.ylabel("t-SNE feature 1")
    plt.title("Text Embeddings t-SNE Visualization")
    plt.show()

# Example texts
texts = ["A photo of a cat", "A photo of a dog",
         "An image of a tree", "A picture of a car",
         "Image of a laptop", "A photo of a house"]

# Generate embeddings
embeddings = generate_text_embeddings(texts)

# Visualize with t-SNE and adjusted annotations
tsne_visualization(embeddings, texts)
