# Installation for OpenDAS

### Requirements
- Linux with Python ≥ 3.8
- PyTorch ≥ 1.8 and [torchvision](https://github.com/pytorch/vision/) that matches the PyTorch installation.
  Install them together at [pytorch.org](https://pytorch.org) to make sure of this. Note, please check
  PyTorch version matches that is required by Detectron2.
- Detectron2: follow [Detectron2 installation instructions](https://detectron2.readthedocs.io/tutorials/install.html).

## Installation for Multi-modal Prompt Learning & OVSeg-OpenDAS

### Usage

Install required packages. 

```bash
conda create --name opendas python=3.9
conda activate opendas
conda install pytorch==1.10.1 torchvision==0.11.2 torchaudio==0.10.1 cudatoolkit=11.3 -c pytorch -c conda-forge
pip install -r requirements.txt
```

You need to download `detectron2==0.6` following [instructions](https://detectron2.readthedocs.io/en/latest/tutorials/install.html)

```bash
python3 -m pip install -U 'git+https://github.com/facebookresearch/detectron2.git@ff53992b1985b63bd3262b5a36167098e3dada02'
```


Install the modified CLIP package, if it is not done so already with pip install.

```bash
cd third_party/CLIP
python -m pip install -Ue .
```

## Installation for OpenMask3D

Please refer to [instructions](./scannetpp-openmask3d-opendas/openmask3d/README.md).