# How to install datasets

We suggest putting all datasets under the same folder (say `$DATA`) to ease management and following the instructions below to organize datasets to avoid modifying the source code. The file structure looks like

```
$DATA/
  ade_20k_150/                # images of ADE gt masks with 150 categories
    ade_gt_150cls_train/      # training set
    ade_gt_150cls_val/        # validation set
    ade20k_150_classnames.txt # 150 classes
    ade_gt_150cls_v3.csv      # meta data for training set
  scannetpp/                  # images of ScanNet++ with gt masks
    scannetpp_sem_seg_train/  # training set
    scannetpp_sem_seg_val/    # validation set
    scannetpp_train_gt.csv    # meta data for only training samples
    scannetpp_train_classes.txt
    scannetpp_val_classes.txt
    scannetpp_semantic_classes.txt # all classes in all ScanNet++
  kitti360/                   # images of KITTI-360 with gt masks
    kitti_360_train/          # training set
    kitti360_train_gt.csv     # meta data for only training samples
    kitti_360_val             # validation set
    kitti360_train_classes.txt
```

If you have some datasets already installed somewhere else, you can create symbolic links in `$DATA/dataset_name` that point to the original data to avoid duplicate download.

Datasets list:
- **ScanNet++ Offices**
- **KITTI-360**
- **ADE20K**
