#!/bin/bash

#SBATCH --job-name=cocoop_train
#SBATCH --gpus=2
#SBATCH --gres=gpumem:40g
#SBATCH --time=24:00:00
#SBATCH --ntasks=4
#SBATCH --mem-per-cpu=50G

module load gcc/8.2.0 python_gpu/3.9.9

# custom config
DATA=./ov-seg-clip/open_clip_training/openclip_data
TRAINER=CoCoOp

DATASET=ade20k_150
SEED=1

CFG=vit_l14_c4_ep5_batch4_ctxv1
SHOTS=0


DIR=output/${DATASET}/${TRAINER}/${CFG}_${SHOTS}shots/seed${SEED}

source ./maple/bin/activate

if [ -d "$DIR" ]; then
    echo "Results are available in ${DIR}. Still dont skip this job"
    echo "Run this job and save the output to ${DIR}"

    python train.py \
    --root ${DATA} \
    --seed ${SEED} \
    --trainer ${TRAINER} \
    --backbone ViT-L/14 \
    --dataset-config-file configs/datasets/${DATASET}.yaml \
    --config-file configs/trainers/${TRAINER}/${CFG}.yaml \
    --output-dir ${DIR} \
    DATASET.NUM_SHOTS ${SHOTS}
else
    echo "Run this job and save the output to ${DIR}"

    python train.py \
    --root ${DATA} \
    --seed ${SEED} \
    --trainer ${TRAINER} \
    --backbone ViT-L/14 \
    --dataset-config-file configs/datasets/${DATASET}.yaml \
    --config-file configs/trainers/${TRAINER}/${CFG}.yaml \
    --output-dir ${DIR} \
    DATASET.NUM_SHOTS ${SHOTS}
fi