#!/bin/bash

#SBATCH --job-name=triplet_ivlp
#SBATCH --gpus=1
#SBATCH --gres=gpumem:50g
#SBATCH --time=24:00:00
#SBATCH --ntasks=2
#SBATCH --mem-per-cpu=50G

module load gcc/8.2.0 python_gpu/3.9.9

# custom config
DATA=./ov-seg-clip/open_clip_training/openclip_data
TRAINER=OpenDAS

DATASET=kitti360_negative
SEED=428

CFG=vit_l14_c2_ep10_batch16_12+12ctx_use_both_losses
SHOTS=0


DIR=output/${DATASET}/${TRAINER}/${CFG}_${SHOTS}shots/seed${SEED}

source ./maple/bin/activate

if [ -d "$DIR" ]; then
    echo "Results are available in ${DIR} but running again."
else
    echo "Run this job and save the output to ${DIR}"
fi

python train.py \
    --root ${DATA} \
    --seed ${SEED} \
    --trainer ${TRAINER} \
    --dataset-config-file configs/datasets/${DATASET}.yaml \
    --config-file configs/trainers/${TRAINER}/${CFG}.yaml \
    --output-dir ${DIR} \
    DATASET.NUM_SHOTS ${SHOTS} \
    TEST.FINAL_MODEL "best_val"