#!/bin/bash

#SBATCH --job-name=rpo_train
#SBATCH --gpus=quadro_rtx_6000:1
#SBATCH --time=12:00:00
#SBATCH --mem-per-cpu=50G

module load gcc/8.2.0 python_gpu/3.9.9

# custom config
DATA="./ov-seg-clip/open_clip_training/openclip_data"
TRAINER=RPOWithTriplet

DATASET=scannetpp_similar_negative_v2
SEED=14

CFG=main_vitl14_b16
SHOTS=0

source ./maple/bin/activate

DIR=output/rpo_with_triplet/base2new/train_base/${DATASET}/shots_${SHOTS}/${TRAINER}/${CFG}/seed${SEED}

python train.py \
--root ${DATA} \
--seed ${SEED} \
--trainer ${TRAINER} \
--dataset-config-file configs/datasets/${DATASET}.yaml \
--config-file configs/trainers/${TRAINER}/${CFG}.yaml \
--output-dir ${DIR} \
DATASET.NUM_SHOTS ${SHOTS} \
DATASET.SUBSAMPLE_CLASSES all
