#!/bin/bash

#SBATCH --job-name=rpo_test
#SBATCH --gpus=quadro_rtx_6000:1
#SBATCH --time=04:00:00
#SBATCH --ntasks=2
#SBATCH --mem-per-cpu=50G

module load gcc/8.2.0 python_gpu/3.9.9

# custom config
DATA="./ov-seg-clip/open_clip_training/openclip_data"
TRAINER=RPOWithTriplet


DATASET=scannetpp
SEED=12
EPOCH=10


CFG=main_vitl14_b8
SHOTS=0

COMMON_DIR=shots_${SHOTS}/${TRAINER}/${CFG}/seed${SEED}
MODEL_DIR=output/rpo_with_triplet/base2new/train_base/scannetpp_negative_semi_hard_list/${COMMON_DIR}

source ./maple/bin/activate

DIR=output/rpo_with_triplet/evaluation/${TRAINER}/${CFG}_${SHOTS}shots/${DATASET}/seed${SEED}
CUDA_VISIBLE_DEVICES=${GPU} python train.py \
    --root ${DATA} \
    --seed ${SEED} \
    --trainer ${TRAINER} \
    --dataset-config-file configs/datasets/${DATASET}.yaml \
    --config-file configs/trainers/${TRAINER}/${CFG}.yaml \
    --output-dir ${DIR} \
    --model-dir ${MODEL_DIR} \
    --load-epoch ${EPOCH} \
    --eval-only