#!/bin/bash

#SBATCH --job-name=demo
#SBATCH --gpus=quadro_rtx_6000:1

module load gcc/8.2.0 python_gpu/3.9.9
export DETECTRON2_DATASETS=./data/

source ./maple/bin/activate

python demo.py \
    --config-file configs/ovseg_swinB_vitL_demo.yaml \
    --class-names 'wall' 'floor'  \
    --input ./data/kitti-360/val/images/2013_05_28_drive_0000_sync_image_00_00000015*0.png \
    --gt ./data/kitti-360/val/semantics/2013_05_28_drive_0000_sync_image_00_00000015*0.png \
    --output ./pred_kitti \
    --opts MODEL.WEIGHTS ./ov-seg/weights/ovseg_swinbase_vitL14_ft_mpt.pth \
    MODEL.CLIP_ADAPTER.MASK_PROMPT_FWD False \
    MODEL.MASK_FORMER.TEST.USE_GT True \
    DATASETS.TEST  \(\"kitti_360_val\",\)  \
    MODEL.CLIP_ADAPTER.TYPE "opendas" \
    MODEL.CLIP_ADAPTER.CLIP_ENSEMBLE_WEIGHT -1.0 # when <= 0, only clip is used