#!/bin/bash

#SBATCH --job-name=background
#SBATCH --gpus=quadro_rtx_6000:4
#SBATCH --time=48:00:00
#SBATCH --mem-per-cpu=50G

torchrun --nproc_per_node 4 -m training.main \
    --train-data ../openclip_data/ade_gt_150cls_v3.csv \
    --train-num-samples 141609 \
    --lr 0.000005 \
    --warmup 100 \
    --force-quick-gelu \
    --dataset-type csv \
    --batch-size 32 \
    --precision amp \
    --workers 4 \
    --model  ViT-L-14 \
    --lock-image \
    --lock-image-unlocked-groups -1 \
    --lock-image-freeze-bn-stats \
    --zeroshot-frequency 1 \
    --save-frequency 5 \
    --epoch 5 \
    --pretrained  openai \
    --ade-val ../openclip_data/ade_gt_150cls_val