#!/bin/bash

#SBATCH --job-name=mask
#SBATCH --gpus=quadro_rtx_6000:1
#SBATCH --time=08:00:00
#SBATCH --mem-per-cpu=50G

python -m training.main \
    --ade-val ../openclip_data/ade20k_150/ade_gt_150cls_val \
    --model ViT-L-14 \
    --mask-emb-depth 3 \
    --with-mask \
    --pretrained ./logs/2023_11_21-16_35_36-mask_prompt_tuning-model_ViT-L-14-lr_0.05-b_32-j_4-p_amp/checkpoints/epoch_5.pt

# ADE20K-150
# VPT: ./logs/2023_11_21-16_35_36-mask_prompt_tuning-model_ViT-L-14-lr_0.05-b_32-j_4-p_amp/checkpoints/epoch_5.pt
# Wise-FT CLIP image: ./logs/2023_11_22-10_03_59-model_ViT-L-14-lr_5e-06-b_32-j_4-p_amp/checkpoints/epoch_5.pt
# Wise-FT CLIP text: ./logs/2023_11_22-13_24_47-model_ViT-L-14-lr_5e-06-b_32-j_4-p_amp/checkpoints/epoch_5.pt

# Scannet++   
# Wise-FT CLIP image: ./logs/2024_01_08-18_00_40-model_ViT-L-14-lr_5e-06-b_32-j_4-p_amp/checkpoints/epoch_11.pt
# VPT: ./logs/2024_01_09-02_45_34-mask_prompt_tuning-model_ViT-L-14-lr_0.05-b_32-j_4-p_amp/checkpoints/epoch_11.pt
# Wise-FT CLIP Text: ./logs/2024_01_08-23_35_09-model_ViT-L-14-lr_5e-06-b_32-j_4-p_amp/checkpoints/epoch_11.pt