#!/bin/bash

#SBATCH --job-name=center_v3
#SBATCH --gpus=quadro_rtx_6000:4
#SBATCH --time=48:00:00
#SBATCH --mem-per-cpu=50G

module load gcc/8.2.0 python_gpu/3.9.9

torchrun --nproc_per_node 4 -m training.main_mask_prompt_tuning \
    --train-data ../openclip_data/kitti360/kitti360_train_gt.csv \
    --csv-img-key filepath \
    --csv-caption-key title \
    --train-num-samples 266147 \
    --lr 0.05 \
    --mask_wd 0.0 \
    --warmup 100 \
    --force-quick-gelu \
    --dataset-type csv \
    --batch-size 32 \
    --precision amp \
    --workers 4 \
    --with-mask \
    --model  ViT-L-14 \
    --mask-emb-depth 3 \
    --lock-text \
    --lock-image \
    --lock-image-unlocked-groups 0 \
    --zeroshot-frequency 5 \
    --save-frequency 5 \
    --epoch 11 \
    --pretrained  openai \
    --kitti360-val ../openclip_data/kitti360/kitti_360_val