#!/bin/bash

#SBATCH --job-name=background
#SBATCH --gpus=quadro_rtx_6000:4
#SBATCH --time=48:00:00
#SBATCH --mem-per-cpu=50G

module load gcc/8.2.0 python_gpu/3.9.9

torchrun --nproc_per_node 4 -m training.main \
    --train-data ../openclip_data/scannetpp_train_gt.csv \
    --train-num-samples 99952 \
    --report-to wandb \
    --lr 0.000005 \
    --warmup 100 \
    --force-quick-gelu \
    --dataset-type csv \
    --batch-size 32 \
    --precision amp \
    --workers 4 \
    --model  ViT-L-14 \
    --lock-text \
    --zeroshot-frequency 5 \
    --save-frequency 5 \
    --epoch 11 \
    --pretrained  openai \
    --scannetpp-val ../openclip_data/scannetpp_sem_seg_val