#!/bin/bash

#SBATCH --job-name=run_opendas
#SBATCH --gpus=quadro_rtx_6000:1
#SBATCH --time=04:00:00
#SBATCH --mem-per-cpu=50G

module load gcc/8.2.0 python_gpu/3.9.9
export DETECTRON2_DATASETS=./data
export MODEL_SAVE_DIR=./multimodal-prompt-learning/output
source ./maple/bin/activate

python train_net.py \
    --num-gpu 1 \
    --eval-only \
    --config-file configs/ovseg_swinB_vitL_bs32_120k.yaml \
    MODEL.WEIGHTS ./weights/ovseg_opendas_ade.pth \
    SOLVER.TEST_IMS_PER_BATCH 2 \
    MODEL.CLIP_ADAPTER.MASK_PROMPT_FWD False \
    MODEL.MASK_FORMER.TEST.USE_GT False \
    MODEL.CLIP_ADAPTER.TYPE "opendas" \
    MODEL.CLIP_ADAPTER.CLIP_ENSEMBLE_WEIGHT -1.0 \
    DATASETS.TEST  \(\"ade20k_full_sem_seg_val\",\) 