#!/usr/bin/env python3
"""
Kitchen Environment Safety Analysis Package Setup
Kitchen environment safety analysis package installation configuration
"""

from setuptools import setup, find_packages
import os

# Read README file
def read_long_description():
    readme_path = os.path.join(os.path.dirname(__file__), "README.md")
    if os.path.exists(readme_path):
        with open(readme_path, "r", encoding="utf-8") as f:
            return f.read()
    return "Kitchen Environment Safety Analysis Package"

# Read requirements file
def read_requirements():
    requirements_path = os.path.join(os.path.dirname(__file__), "requirements.txt")
    if os.path.exists(requirements_path):
        with open(requirements_path, "r", encoding="utf-8") as f:
            return [line.strip() for line in f if line.strip() and not line.startswith("#")]
    return ["owlready2>=0.45"]

setup(
    name="kitchen-safety-analyzer",
    version="1.0.0",
    author="Kitchen Safety Team",
    author_email="safety@kitchen.ai",
    description="Kitchen environment action sequence safety analysis package",
    long_description=read_long_description(),
    long_description_content_type="text/markdown",
    url="https://github.com/kitchen-ai/safety-analyzer",
    packages=find_packages(),
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Topic :: Scientific/Engineering :: Artificial Intelligence",
        "Topic :: Software Development :: Libraries :: Python Modules",
    ],
    python_requires=">=3.8",
    install_requires=read_requirements(),
    include_package_data=True,
    package_data={
        "verify_core": [
            "ontology/*.owl",
            "ontology/core/*.owl", 
            "ontology/domain/*.owl",
            "src/*.json",
            "data/*.json"
        ],
    },
    entry_points={
        "console_scripts": [
            "kitchen-safety=verify_core.safety_analyzer:main",
        ],
    },
    keywords="safety analysis, kitchen environment, action sequence, ontology reasoning",
    project_urls={
        "Bug Reports": "https://github.com/kitchen-ai/safety-analyzer/issues",
        "Source": "https://github.com/kitchen-ai/safety-analyzer",
    },
)
