import os
from openai import OpenAI
from logger import logger

api_key = os.getenv("API_KEY")
base_url = os.getenv("BASE_URL")
client = OpenAI(api_key=api_key, base_url=base_url)
default_model = os.getenv("MODEL")


def ask_llm(
    prompt: str, image: str | None = None, extra_messages: list[dict] | None = None
):
    logger.info("Ask LLM with prompt: %s", prompt.strip().splitlines()[0] + "...")

    if image and os.environ.get("HACK_QWEN_NO_IMAGE") != "1":
        messages = [
            {
                "role": "user",
                "content": [
                    {"type": "text", "text": prompt},
                    {"type": "image_url", "image_url": {"url": f"data:image/png;base64,{image}"}},
                ],
            }
        ]
    else:
        messages = [{"role": "user", "content": prompt}]

    if extra_messages:
        messages.extend(extra_messages)

    response = client.chat.completions.create(
        model=default_model,  # type: ignore
        messages=messages,  # type: ignore
        temperature=0.1,
        timeout=120,  
    )
    content = response.choices[0].message.content
    assert isinstance(content, str)
    logger.info("LLM Response: %s", content)
    return content
