import tensorflow as tf


class Model(tf.keras.Model):
    """
    CNN model
    """
    def __init__(self, n_channel, pred_len, kernel_size):
        super(Model, self).__init__()
        self.cnn = tf.keras.layers.Conv1D(n_channel, kernel_size, padding='same', input_shape=(None, n_channel))
        self.dense = tf.keras.layers.Dense(pred_len)

    def call(self, x):
        # x: [Batch, Input length, Channel]
        x = self.cnn(x)
        x = tf.transpose(x, perm=[0, 2, 1]) # [Batch, Channel, Input Length]
        x = self.dense(x)
        x = tf.transpose(x, perm=[0, 2, 1]) # [Batch, Channel, Input Length]
        return x # [Batch, Output length, Channel]
