# TSMixer with Auxiliary Information

This implementation is based on [GluonTS](https://github.com/awslabs/gluonts).
The main modifications are in [src/gluonts/torch/model/tsmixer/](src/gluonts/torch/model/tsmixer/).

## Installation
1. Install [PyTorch](https://pytorch.org/)
2. Install modified GluonTS from this repository
```bash
pip install -e .
```
3. (Optional) Install [MXNet](https://mxnet.apache.org/versions/master/get_started?) if you want to try other models provided in GluonTS.

## Data Preparation
Download the M5 dataset from [Kaggle](https://www.kaggle.com/competitions/m5-forecasting-accuracy/data).
Put `calendar.csv`, `sell_prices.csv`, `sales_train_evaluation.csv` in `data/` directory.

## Training Example
Train TSMixer with tuned hyperparameters.
```bash
python run_m5.py --model tsmixer --n_block 2 --hidden_size 64 --dropout 0
```
