"""General Registry."""

from typing import Any


class Registry(object):
  """Registry."""

  def __init__(self, shared_state):
    self.__dict__ = shared_state
    # Rare race condition here, this line makes the class not thread safe.
    self.registry_map = (
        self.registry_map if hasattr(self, "registry_map") else {})

  def register(
      self, name: str, item: Any) -> None:
    """Registers callable with name."""
    if name in self.registry_map:
      raise ValueError("%s already registered!" % name)
    self.registry_map[name] = item

  def lookup(self, name: str) -> Any:
    """Look ups callable with name."""
    if name not in self.registry_map:
      valid_names = "\n".join(self.registry_map.keys())
      raise ValueError(
          "%s not registered!\n\n"
          "Valid names:%s\n\n"
          "Perhaps you forgot to import {datasets.py,models.py,tokenizers.py}" %
          (name, valid_names))
    return self.registry_map[name]