# Supplementary Materials

This repository contains the supplementary materials for our paper submission, including code implementations, datasets.

## Directory Structure

### 📁 `datasets/`
Training and evaluation datasets:
- `clean_train.jsonl` - Cleaned training dataset
- `clean_validation.jsonl` - Cleaned validation dataset

### 📁 `code_flywheel/`
Main project implementation with modular architecture:

**🚀 Entry Point:**
- `run_pipeline.sh` - **Main script** to execute the complete data processing pipeline

**Supporting Components:**
- `modules/` - Core module implementations
- `infer/` - Inference engine and utilities
- `logs/` - Logging and monitoring outputs
- `setup.py` - Package installation script
- `architecture.md` - Detailed system architecture documentation
- `global_config.py` - Global configuration settings

### 📁 `code_RLVR_IntentCheck/`
Contains the implementation of RLVR with intent checking mechanisms:

**🚀 Entry Points:**
- `run_qwen2_5-32b.sh` - **Main script** to run experiments with Qwen2.5-32B model
- `run_qwen2_5-7b.sh` - **Main script** to run experiments with Qwen2.5-7B model

**Supporting Components:**
- `reward/` - Reward implementations
- `reward_manager/` - Reward management  

### 📁 `code_tripwires/`
Analysis tools and tripwire detection mechanisms:

**🚀 Entry Point:**
- `run_hacking_prob.sh` - **Main script** to execute hacking probability analysis

**Supporting Components:**
- `analysis.py` - Main analysis script for experimental results
- `rule_based_hacking_prob.py` - Rule-based probability estimation for hacking detection
- `probe.jsonl` - Probe dataset for testing
- `figures/` - Generated figures and visualizations
- `log/` - Analysis logs and outputs
