import logging
from colorlog import ColoredFormatter

# 禁用不需要的日志
logging.getLogger('httpx').setLevel(logging.WARNING)

# 直接配置主logger
logger = logging.getLogger(__name__)
logger.setLevel(logging.INFO)

# 移除所有现有Handler避免重复
logger.handlers = []

# 创建ColoredFormatter (更可靠的颜色管理)
formatter = ColoredFormatter(
    "%(log_color)s%(asctime)s - %(name)s - %(levelname)s - %(message)s (%(filename)s:%(lineno)d)",
    datefmt="%Y-%m-%d %H:%M:%S",
    reset=True,
    log_colors={
        'DEBUG': 'cyan',
        'INFO': 'green',
        'WARNING': 'yellow',
        'ERROR': 'red',
        'CRITICAL': 'red,bg_white',
    }
)

# 配置Handler
ch = logging.StreamHandler()
ch.setFormatter(formatter)
logger.addHandler(ch)

# 禁止传播到root logger
logger.propagate = False
