from setuptools import setup, find_packages

setup(
    version="0.1.0",
    description="A sandbox for instruction fine-tuning with quality control and enhancement features",
    packages=find_packages(include=['modules*', 'infer*']),
    install_requires=[
        "openai",
        "tqdm",
        "absl-py",
        "python-dotenv",
        "langdetect",
        "torch",
        "numpy",
        "immutabledict",
    ],
    python_requires=">=3.6",
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Science/Research",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
    ],
    keywords="instruction-tuning, language-models, fine-tuning, nlp",
) 