import gym
import gym_minigrid


class MGCostWrapper(gym.Wrapper):
    def __init__(self, env: gym_minigrid.gym_minigrid.envs.MiniGridEnv):
        super().__init__(env)
        assert hasattr(env, "grid")
        self.env = env

    def step(self, action):
        cost = self.get_cost(action)
        obs, reward, done, info = self.env.step(action)
        if done and self.env.get(self.env.agent_pos) != "goal":
            done = False
        return obs, [reward, cost], done, info 

    
    def get_cost(self, action):
        """
            Returns the cost
        """
        front_cell = self.env.grid.get(*self.env.front_pos)
        not_clear = front_cell and front_cell.type != 'goal'

        if action == self.actions.forward and not_clear:
            return 1.
        else:
            return 0.
