import numpy as np
import pandas 
import glob

def smooth(ts, wind=10):
    pdts = pandas.Series(ts)
    return pdts.rolling(window=wind).mean()

def keep_numeric(lst):
    out = []
    for i in lst:
        try:
            out.append(float(i))
        except:
            pass
    return out

def synthesize(env_name, dir_name, eps=None, nA=None, ud=None):
    dir_name = dir_name + "/" + env_name
    if nA:
        dir_name += "_nA"
    if ud:
        dir_name += "_ud"
    if eps:
        eps_name = ""
        for e in eps:
            eps_name += str(e)
        dir_name = dir_name + "_epsilon_" + eps_name
    dir_name += "_seed_*"
    dirs = glob.glob(dir_name)

    frames = []
    rpe1 = []
    rpe2 = []
    eps = []
    ploss = []
    for dir in dirs:
        table = pandas.read_csv(dir + "/log.csv")
        frames.append(keep_numeric(table.frames.to_numpy().tolist()))
        rpe1.append(keep_numeric(table.RPE1_mean.to_numpy().tolist()))
        rpe2.append(keep_numeric(table.RPE2_mean.to_numpy().tolist()))
        eps.append(keep_numeric(table.epsilon.to_numpy().tolist()))
        ploss.append(keep_numeric(table.mu.to_numpy().tolist()))

    # keep only those that have same length
    lens = [len(frame) for frame in frames]
    lensset = list(set(lens))
    if len(lensset) > 1:
        cnt1 = lens.count(lensset[0])
        cnt2 = lens.count(lensset[1])
        item = lensset[0]
        if cnt2 < cnt1:
            item = lensset[1]
        indx = lens.index(item) 

        frames.pop(indx)
        rpe1.pop(indx)
        rpe2.pop(indx)
        eps.pop(indx)
        ploss.pop(indx)

    frames = np.array(frames)
    rpe1 = np.array(rpe1)
    rpe2 = np.array(rpe2)
    eps = np.array(eps)
    ploss = np.array(ploss)

    return frames, rpe1, rpe2, eps, ploss

def pareto_dominance(reward_1, reward_2):
    # inputs are N_seeds x ep_len x reward_dim
    N = min(reward_1.shape[0], reward_2.shape[0])
    pd = []
    for n in range(N):
        r1 = reward_1[n]
        r2 = reward_2[n]
        pdn = []
        for t in range(r1.shape[0]):
            tv = 1 if all(r1[t] >= r2[t]) else 0
            pdn.append(tv)
        pd.append(pdn)
    return np.array(pd).astype(int)

def avg_utility(reward):
    # input is N_seeds x epis_len x reward_dim
    N = reward.shape[0]
    e_len = reward.shape[1]
    reward_dim = reward.shape[-1]
    for dim in range(reward_dim):
        reward[:,:,dim] /= np.max(np.abs(reward[:,:,dim]))

    N_samples = 1000^(reward_dim - 1)
    ut = np.zeros(shape=(N_samples, N, e_len))
    for ns in range(N_samples):
        pref = np.zeros(shape=(2,))
        pref[:1] = np.random.rand(reward_dim-1)
        pref[-1] = 1 - pref[:-1]
        ut[ns] = np.dot(reward,pref)

    ut = np.mean(ut, axis=0)
    return ut
