folder=$1
CHECK_BEST=checkpoints/$folder
DATASET=data-bin/
WHICH_CUDA=0,1,2,3
#BEAM=1
LENPEN=1.0
BATCHSIZE=200
if [[ $folder == *"iwslt14"* ]]; then
	TESTDATASET=iwslt14
elif [[ $folder == *"iwslt15"* ]]; then
  TESTDATASET=iwslt15-en-vi
elif [[ $folder == *"multi30k"* ]]; then
  TESTDATASET=multi30k.tokenized.de-en
fi

#
#CUDA_VISIBLE_DEVICES=$WHICH_CUDA python fairseq_cli/generate.py ${DATASET}${TESTDATASET}/ --path ${CHECK_BEST}/checkpoint_best.pt --gen-subset test --beam $BEAM --batch-size $BATCHSIZE --remove-bpe  --lenpen $LENPEN --results-path ${CHECK_BEST}/BEAM${BEAM}_${LENPEN} 

#SPLIT CODE
#grep ^T ${CHECK_BEST}/BEAM${BEAM}_${LENPEN}/generate-test.txt | cut -f2- > ${CHECK_BEST}/BEAM${BEAM}_${LENPEN}/target.txt
#grep ^H ${CHECK_BEST}/BEAM${BEAM}_${LENPEN}/generate-test.txt | cut -f3- > ${CHECK_BEST}/BEAM${BEAM}_${LENPEN}/hypotheses.txt

BEAM=4
CUDA_VISIBLE_DEVICES=$WHICH_CUDA python fairseq_cli/generate.py ${DATASET}${TESTDATASET}/ --path ${CHECK_BEST}/checkpoint_best.pt --gen-subset test --beam $BEAM --batch-size $BATCHSIZE --remove-bpe  --lenpen $LENPEN --results-path ${CHECK_BEST}/BEAM${BEAM}_${LENPEN}

#SPLIT CODE
grep ^T ${CHECK_BEST}/BEAM${BEAM}_${LENPEN}/generate-test.txt | cut -f2- > ${CHECK_BEST}/BEAM${BEAM}_${LENPEN}/target.txt
grep ^H ${CHECK_BEST}/BEAM${BEAM}_${LENPEN}/generate-test.txt | cut -f3- > ${CHECK_BEST}/BEAM${BEAM}_${LENPEN}/hypotheses.txt

# Compute automatic scores
python calculateScore.py checkpoints/$folder/BEAM4_1.0/ > checkpoints/$folder/scores.txt

# Compute ECE
CHECK_BEST=checkpoints/$folder
DATASET=/mount/data
DATASET=data-bin/
WHICH_CUDA=4,5,6,7
BEAM=1
LENPEN=1.0
BATCHSIZE=128
if [[ $folder == *"iwslt14"* ]]; then
	TESTDATASET=iwslt14
elif [[ $folder == *"iwslt15"* ]]; then
  TESTDATASET=iwslt15-en-vi
elif [[ $folder == *"multi30k"* ]]; then
  TESTDATASET=multi30k.tokenized.de-en
fi
CUDA_VISIBLE_DEVICES=$WHICH_CUDA python fairseq_cli/ece.py ${DATASET}${TESTDATASET}/ --path ${CHECK_BEST}/checkpoint_best.pt --gen-subset test --beam $BEAM --batch-size $BATCHSIZE --remove-bpe  --lenpen $LENPEN