#include <stdlib.h>
#include <exception>
#include <set>
#include <algorithm>
#include <sstream>
#include "mm_Game.h"

namespace mm{

Game::Game( const unsigned numPeg,
            const unsigned numColor )
{
    _code.resize( numPeg );
    if( numColor < 2 ) throw std::runtime_error("invalid number of colors");
    for( unsigned i=0; i<numPeg; i++ ) _code[i] = rand() % numColor;
}

std::pair<unsigned,unsigned> 
Game::feedback( const std::vector<unsigned>&  guess )
{
    unsigned size = guess.size();
    if( size != _code.size()) throw std::runtime_error("code length mismatch");
    return get_feedback( guess, _code );
}

std::string
Game::code()
{
    return code_to_string( _code );
}

std::string
code_to_string( const std::vector<unsigned>& code )
{
    std::string buf = std::to_string(code[0]);
    for( unsigned i=1; i<code.size(); i++ ) buf += "_" + std::to_string(code[i]);
    return buf;
}

std::string
pair_to_string( const std::pair<unsigned,unsigned>& pair )
{
    return std::to_string(pair.first)+"_"+std::to_string(pair.second);
}

std::pair<unsigned,unsigned>
get_feedback( const std::vector<unsigned>&  guess,
              const std::vector<unsigned>&  code )
{
    unsigned size = guess.size();
    std::pair<unsigned,unsigned> feedback;
    feedback.first = 0;
    feedback.second = 0;
    std::set<unsigned> colors;
    for( unsigned i=0; i<size; i++ ){
        if( guess[i] == code[i] ) feedback.first++;
        if( colors.find( guess[i] ) != colors.end()) continue;
        unsigned c1=0, c2=0;
        for( unsigned ii=0; ii<size; ii++ ){
            if( guess[ii] == guess[i] ) c1++;
            if(  code[ii] == guess[i] ) c2++;
        }
        colors.insert( guess[i] );
        feedback.second += std::min(c1,c2);
    }
    feedback.second -= feedback.first;
    return feedback;
}

}

