#include <iostream>
#include <fstream>
#include <string>
#include <sstream>
#include <pthread.h>
#include <vector>
#include <set>
#include <dirent.h>
#include <algorithm>

static void
split( const std::string& line,
       std::vector<std::string>& words )
{
    words.clear();
    std::stringstream ss( line );
    while( ss.good() ){
        std::string buf;
        ss >> buf;
        if( buf.find_first_not_of(' ') != std::string::npos ) words.push_back( buf );
    }
}

static std::vector<double>
read_probs( const std::string& filename )
{
    std::vector<double> probs;
    std::ifstream is( filename.c_str() );
    while( is.good() ){
        double buf;
        is >> buf;
        probs.push_back( buf );
    }
    is.close();
    return probs;
}

struct Formula{
    int i1,i2;
    bool isAnd;
};

int
main( int argc, const char* argv[] )
{
    int position = 1;
    std::string configFile;
    std::string inputDir;
    while( position < argc ){
        if( argv[position][0] != '-' ){
            std::cout << "Wrong usage: invalid argument \""
                      << argv[position] << "\".\n";
            return 1;
        }
        std::string buf( argv[position] );
        if(( buf == "-gameConfig" )&&( argc > position+2 )){
            configFile= std::string( argv[position+1] );
            position += 2;
        }
        else if(( buf == "-inputDir" )&&( argc > position+1 )){
            inputDir  = std::string( argv[position+1] );
            position += 2;
        }
        else{
            std::cout << "Wrong usage: invalid argument \""
                      << argv[position] << "\".\n";
            return 1;
        }
    }
    DIR *dir = opendir(inputDir.c_str());
    struct dirent *ent;
    std::vector<std::string> gamefiles;
    while((ent = readdir(dir)) != NULL){
        std::string buf = ent->d_name;
        if( buf.find("game_") == std::string::npos ) continue;
        if( buf.find("prob") != std::string::npos ) continue;
        gamefiles.push_back( inputDir + "/" + buf );
    }
    std::sort( gamefiles.begin(), gamefiles.end());
    closedir(dir);
    unsigned numGame = gamefiles.size();
    std::ifstream is( configFile.c_str());
    std::string buffer;
    std::getline( is, buffer );
    std::vector<std::string> words;
    split( buffer, words );
    double lb = std::stod( words[1] );
    double ub = std::stod( words[2] );
    std::vector<Formula> fs;
    while( is.good()){
        std::getline( is, buffer );
        if( buffer.find("knowledge") == std::string::npos) continue;
        split( buffer, words );
        if( words.size() != 4 ) throw std::runtime_error(std::string("invalid line ")+buffer);
        Formula buf;
        buf.i1 = std::stoi( words[1] );
        buf.i2 = std::stoi( words[3] );
        buf.isAnd = (words[2] == "and");
        fs.push_back(buf);
    }
    is.close();
    std::cout << "adding clues to " << numGame << " puzzles\n";
    time_t start,end;
    time(&start);
    for( unsigned i=0; i<numGame; i++ ){
        is.open(gamefiles[i].c_str());
        unsigned count = 0;
        while(1){
            std::getline( is, buffer );
            if( buffer.find("correct") != std::string::npos ) break;
            count++;
        }
        is.close();
        count -= 2;
        std::vector<double> probs = read_probs( gamefiles[i]+".prob" );
        std::ofstream os( (gamefiles[i]+".prob.clues").c_str() );
        for( unsigned ii=0; ii<fs.size(); ii++ ){
            if( fs[ii].i1 >= count ) continue;
            if( fs[ii].i2 >= count ) continue;
            if( fs[ii].isAnd ){
                double value = probs[fs[ii].i1]*probs[fs[ii].i2];
                double vlb = lb*lb;
                double vub = ub*ub;
                os << fs[ii].i1 << " and " << fs[ii].i2 << " "
                   << vlb + (value-vlb)*double(rand())/double(RAND_MAX) << " "
                   << value + (vub-value)*double(rand())/double(RAND_MAX) << "\n";
            }
            else{
                double value = 1-(1.-probs[fs[ii].i1])*(1.-probs[fs[ii].i2]);
                double vlb = lb + lb - lb*lb;
                double vub = ub + ub - ub*ub;
                os << fs[ii].i1 << " or " << fs[ii].i2 << " "
                   << vlb + (value-vlb)*double(rand())/double(RAND_MAX) << " "
                   << value + (vub-value)*double(rand())/double(RAND_MAX) << "\n";
            }
        }
        os.close();
    }
    time(&end);
    std::cout << "Runtime: " << difftime(end,start) << " seconds\n";
    return 0;
}

