#ifndef MM_CREDALGAME_H
#define MM_CREDALGAME_H

#include "mm_BayesGame.h"

namespace mm{

class CredalGame: public Game{
 public:
    CredalGame( const unsigned,
                const unsigned,
                const std::vector<std::string>&,
                const std::vector<bool>&,
                int seed=-1 );
    virtual ~CredalGame(){}
    std::pair<unsigned,unsigned> feedback( const std::vector<unsigned>&);
    double stats( std::ostream& os );
    void writeProbFile( const std::string& );
private:
    double _lb, _ub;
    int _seed;
    std::vector<double> _lieProbs;
    std::vector<std::vector<unsigned> >        _all;
    std::vector<std::vector<unsigned> >        _historyG;
    std::vector<std::pair<unsigned,unsigned> > _historyF;
    std::vector<unsigned>                      _historyM;
    void preCalcLieprobs( const std::vector<std::string>&,
                          const std::vector<bool>& );
};

}

#endif


