from xgboost import XGBClassifier, XGBRegressor

from common.constants import CALIFORNIA_HOUSING, CHURN, MODEL, PARAMS

xgboost_params = {
    CALIFORNIA_HOUSING: {
        MODEL: XGBRegressor,
        PARAMS: {'max_depth': 10,
                 'learning_rate': 0.08834489002327134,
                 'n_estimators': 540,
                 'min_child_weight': 2,
                 'gamma': 0.22930409652905961,
                 'subsample': 0.8564295577746326,
                 'colsample_bytree': 0.6418883265743276,
                 'reg_alpha': 0.6821615822707534,
                 'reg_lambda': 0.7998780097249603,
                 'random_state': 720}
    },
    CHURN: {
        MODEL: XGBClassifier,
        PARAMS: {'max_depth': 7,
                 'learning_rate': 0.03141132226832096,
                 'n_estimators': 424,
                 'min_child_weight': 7,
                 'gamma': 6.940401833989778e-07,
                 'subsample': 0.9711104458860201,
                 'colsample_bytree': 0.26930292830573177,
                 'reg_alpha': 1.4149691556162199e-05,
                 'reg_lambda': 0.035011428364557604}
    }
}
