# -*- coding: utf-8 -*-

u"""
(c) Copyright 2023 Telefónica. All Rights Reserved.
The copyright to the software program(s) is property of Telefónica.
The program(s) may be used and or copied only with the express written consent of Telefónica or in accordance with the
terms and conditions stipulated in the agreement/contract under which the program(s) have been supplied."""

import os

CONF_DIR = os.path.join(os.path.dirname(__file__), '..', 'conf')

CALIFORNIA_HOUSING = 'california'
CHURN = 'churn'

# Fields of the metadata dictionary
CAT = 'categories'
DEFAULT = 'default'
INDEX = 'index'
FREQ = 'frequencies'
NAME = 'name'
NCAT = 'ncat'
ONEHOT = 'onehot'
PROBLEM_TYPE = 'problem_type'
STRUCT = 'structure'
TARGET = 'target'
TYPE = 'type'
WEIGHTS = 'weights'

QUAL = 'qualitative'
QUAN = 'quantitative'

TRAIN_SIZE_GEN = 'gen_train_size'


# Config json
ACCURACY = 'Accuracy'
CHECKPOINT_PATH = 'checkpoint_path'
CHUNK_SIZE = 'chunk_size'
CLASSIFICATION = 'classification'
COMMON = 'common'
CPU = 'cpu'
CUDA = 'cuda'
CURRENT_MODEL_NAME = 'current_model_name'
DEVICE = 'device'
EPOCHS = 'epochs'
ML_UTILITY_OUT_PATH = 'ml_utility_out_path'
FREQUENCY = "frequency"
LATENT_SPACE_SIZE = 'latent_space_size'
LEARNING_RATE = 'learning_rate'
TRAIN_LOAD_FROM_CHECKPOINT = 'train_load_from_checkpoint'
MACRO_F1 = 'MacroF1'
MASK_COL_NUMBER = 'mask_col_number'
MASK_COL_NUMBER_CONSTANT = 'mask_col_number_constant'
MASK_INCLUDE_TARGET = 'mask_include_target'
MASK_PARAMS = 'mask_params'
MAX_COL_TO_MASK = 'max_col_to_mask'
MIN_COL_TO_MASK = 'min_col_to_mask'
MODEL = 'model'
MODEL_PARAMS = 'model_params'
MODEL_TYPE = 'model_type'
MSE = 'MSE'
OPTIMIZER_PARAMS = 'optimizer_params'
PARAMS = 'params'
PROMPT = 'prompt'
REGRESSION = 'regression'
SEED = 'seed'
ML_UTILITY_TEST_PARAMS = 'ml_utility_test_params'
TEST_BATCH_SIZE = 'test_batch_size'
TIMESTEPS = 'timesteps'
TRAIN_BATCH_SIZE = 'train_batch_size'
TRAIN_PARAMS = 'train_params'
TRANSFORMER = 'transformer'
TRANSFORMER_FEEDFORWARD_SIZE = 'transformer_feedforward_size'
TRANSFORMER_HEADS = 'transformer_heads'
TRANSFORMER_LAYER_NUM = 'transformer_layer_num'
WEIGHTED_F1 = 'WeightedF1'

# EXPERIMENTS
COL_NUMBER = 'Col_Number'
DATASET = 'Dataset'
DISCRIMINATIVE_MODEL = 'Discriminative_Model'
EXPERIMENT_NAME = 'Experiment_Name'
GENERATIVE_MODEL = 'Generative_Model'

experiment_cols = [EXPERIMENT_NAME, DATASET, GENERATIVE_MODEL, DISCRIMINATIVE_MODEL, COL_NUMBER,
                   'Ori_MSE', 'Ori_Accuracy', 'Ori_MacroF1', 'Ori_WeightedF1',
                   'Masked_MSE', 'Masked_Accuracy', 'Masked_MacroF1', 'Masked_WeightedF1']
