from coopt.client_list import *



def get_size(model_type: str):
    value = [0, 0]
    if "resnet18_modified" in model_type:
        value[1] = 512
        if "Tiny" in model_type:
            value[0] = 64
        else:
            value[0] = 32
    elif "vit_tiny_patch16_224" in model_type:
        value[0] = 224
        value[1] = 192
    elif "resnet50" in model_type:
        value[0] = 224
        value[1] = 2048
    elif "human" in model_type:
        value[0] = 0
        value[1] = 0
    
    return tuple(value)


CLIENT_COMB = {
    'comb_cf100_continuous':[
        
    ],
    'comb_fig3bc':[
        (byol_cf10_res18m, get_size(byol_cf10_res18m)),
        (supce_cf10_res18m, get_size(supce_cf10_res18m)),
        # (supce_in1k_vt16_224, get_size(supce_in1k_vt16_224)),
        # (random_tin_res18m, get_size(random_tin_res18m)),
        # (byol_cf10_res18m, get_size(byol_cf10_res18m)),
        # (byol_cf10_vt16_224, get_size(byol_cf10_vt16_224)),
    ],
    'comb_table2': [
        (byol_cf10_res18m, get_size(byol_cf10_res18m)),
        (byol_cf10_vt16_224, get_size(byol_cf10_vt16_224)),
        (byol_cf100_res18m, get_size(byol_cf100_res18m)),
        (byol_cf100_vt16_224, get_size(byol_cf100_vt16_224)),
        (byol_in1k_res50, get_size(byol_in1k_res50)),
        (byol_in1k_vt16_224, get_size(byol_in1k_vt16_224)),
        (byol_tin_res18m, get_size(byol_tin_res18m)),
        (byol_tin_vt16_224, get_size(byol_tin_vt16_224)),

        (supce_cf10_res18m, get_size(supce_cf10_res18m)),
        (supce_cf10_vt16_224, get_size(supce_cf10_vt16_224)),
        (supce_cf100_res18m, get_size(supce_cf100_res18m)),
        (supce_cf100_vt16_224, get_size(supce_cf100_vt16_224)),
        (supce_in1k_res50, get_size(supce_in1k_res50)),
        (supce_in1k_vt16_224, get_size(supce_in1k_vt16_224)),
        (supce_tin_res18m, get_size(supce_tin_res18m)),
        (supce_tin_vt16_224, get_size(supce_tin_vt16_224)),

    ], # table2
    'comb_table3_cf10': [
        (byol_cf10_res18m, get_size(byol_cf10_res18m)),
        (byol_cf10_vt16_224, get_size(byol_cf10_vt16_224)),
        (supce_cf10_res18m, get_size(supce_cf10_res18m)),
        (supce_cf10_vt16_224, get_size(supce_cf10_vt16_224)),
    ], # for e.x., client model is trained on cf10
    'comb_table3_cf100': [
        (byol_cf100_res18m, get_size(byol_cf100_res18m)),
        (byol_cf100_vt16_224, get_size(byol_cf100_vt16_224)),
        (supce_cf100_res18m, get_size(supce_cf100_res18m)),
        (supce_cf100_vt16_224, get_size(supce_cf100_vt16_224)),
    ],
    'comb_table3_tin': [
        (byol_tin_res18m, get_size(byol_tin_res18m)),
        (byol_tin_vt16_224, get_size(byol_tin_vt16_224)),
        (supce_tin_res18m, get_size(supce_tin_res18m)),
        (supce_tin_vt16_224, get_size(supce_tin_vt16_224)),
    ],
    'comb_table3_in1k': [
        (byol_in1k_res50, get_size(byol_in1k_res50)),
        (byol_in1k_vt16_224, get_size(byol_in1k_vt16_224)),
        (supce_in1k_res50, get_size(supce_in1k_res50)),
        (supce_in1k_vt16_224, get_size(supce_in1k_vt16_224)),
    ],
    'comb_table5_human': [
        (human, get_size(human)),
        (human, get_size(human)),
        (human, get_size(human)),
        (human, get_size(human)),
        (human, get_size(human)),
        (human, get_size(human)),
        (human, get_size(human)),
        (human, get_size(human)),
        (human, get_size(human)),
        (human, get_size(human)),

        (byol_cf10_res18m, get_size(byol_cf10_res18m)),
        (byol_cf10_vt16_224, get_size(byol_cf10_vt16_224)),
        (byol_cf100_res18m, get_size(byol_cf100_res18m)),
        (byol_cf100_vt16_224, get_size(byol_cf100_vt16_224)),
        (byol_in1k_res50, get_size(byol_in1k_res50)),
        (byol_in1k_vt16_224, get_size(byol_in1k_vt16_224)),
        (byol_tin_res18m, get_size(byol_tin_res18m)),
        (byol_tin_vt16_224, get_size(byol_tin_vt16_224)),

        (supce_cf10_res18m, get_size(supce_cf10_res18m)),
        (supce_cf10_vt16_224, get_size(supce_cf10_vt16_224)),
        (supce_cf100_res18m, get_size(supce_cf100_res18m)),
        (supce_cf100_vt16_224, get_size(supce_cf100_vt16_224)),
        (supce_in1k_res50, get_size(supce_in1k_res50)),
        (supce_in1k_vt16_224, get_size(supce_in1k_vt16_224)),
        (supce_tin_res18m, get_size(supce_tin_res18m)),
        (supce_tin_vt16_224, get_size(supce_tin_vt16_224)),

    ], # for e.x., add 10 human, change trainset
    'comb_table5_0.5_model': [
        (byol_cf10_res18m_half, get_size(byol_cf10_res18m_half)),
        (byol_cf10_vt16_224_half, get_size(byol_cf10_vt16_224_half)),
        (byol_cf100_res18m_half, get_size(byol_cf100_res18m_half)),
        (byol_cf100_vt16_224_half, get_size(byol_cf100_vt16_224_half)),
        (byol_in1k_res50_half, get_size(byol_in1k_res50_half)),
        (supce_cf10_res18m_half, get_size(supce_cf10_res18m_half)),
        (supce_cf10_vt16_224_half, get_size(supce_cf10_vt16_224_half)),
        (supce_cf100_res18m_half, get_size(supce_cf100_res18m_half)),
        (supce_cf100_vt16_224_half, get_size(supce_cf100_vt16_224_half)),
        (supce_in1k_res50_half, get_size(supce_in1k_res50_half)),

        (byol_cf10_res18m, get_size(byol_cf10_res18m)),
        (byol_cf10_vt16_224, get_size(byol_cf10_vt16_224)),
        (byol_cf100_res18m, get_size(byol_cf100_res18m)),
        (byol_cf100_vt16_224, get_size(byol_cf100_vt16_224)),
        (byol_in1k_res50, get_size(byol_in1k_res50)),
        (byol_in1k_vt16_224, get_size(byol_in1k_vt16_224)),
        (byol_tin_res18m, get_size(byol_tin_res18m)),
        (byol_tin_vt16_224, get_size(byol_tin_vt16_224)),

        (supce_cf10_res18m, get_size(supce_cf10_res18m)),
        (supce_cf10_vt16_224, get_size(supce_cf10_vt16_224)),
        (supce_cf100_res18m, get_size(supce_cf100_res18m)),
        (supce_cf100_vt16_224, get_size(supce_cf100_vt16_224)),
        (supce_in1k_res50, get_size(supce_in1k_res50)),
        (supce_in1k_vt16_224, get_size(supce_in1k_vt16_224)),
        (supce_tin_res18m, get_size(supce_tin_res18m)),
        (supce_tin_vt16_224, get_size(supce_tin_vt16_224)),

    ], # for e.x., add 10 train-0.5 model, change trainset
    # table6 cf100
    'comb_table6_cf100': [
        (byol_cf10_res18m, get_size(byol_cf10_res18m)),
        (byol_cf10_vt16_224, get_size(byol_cf10_vt16_224)),
        (byol_cf100_res18m, get_size(byol_cf100_res18m)),
        (byol_cf100_vt16_224, get_size(byol_cf100_vt16_224)),
        (byol_in1k_res50, get_size(byol_in1k_res50)),
        (byol_in1k_vt16_224, get_size(byol_in1k_vt16_224)),
        (byol_tin_res18m, get_size(byol_tin_res18m)),
        (byol_tin_vt16_224, get_size(byol_tin_vt16_224)),

        (supce_cf10_res18m, get_size(supce_cf10_res18m)),
        (supce_cf10_vt16_224, get_size(supce_cf10_vt16_224)),
        (supce_cf100_res18m, get_size(supce_cf100_res18m)),
        (supce_cf100_vt16_224, get_size(supce_cf100_vt16_224)),
        (supce_in1k_res50, get_size(supce_in1k_res50)),
        (supce_in1k_vt16_224, get_size(supce_in1k_vt16_224)),
        (supce_tin_res18m, get_size(supce_tin_res18m)),
        (supce_tin_vt16_224, get_size(supce_tin_vt16_224)),
    ], # for e.x., train model on cf100, align to best/medium/worst
    'comb_table6_tin': [],
    # fig11 cf100
    'comb_fig11_cf100': [
        (byol_cf10_res18m, get_size(byol_cf10_res18m)),
        (byol_cf10_vt16_224, get_size(byol_cf10_vt16_224)),
        (byol_cf100_res18m, get_size(byol_cf100_res18m)),
        (byol_cf100_vt16_224, get_size(byol_cf100_vt16_224)),
        (byol_in1k_res50, get_size(byol_in1k_res50)),
        (byol_in1k_vt16_224, get_size(byol_in1k_vt16_224)),
        (byol_tin_res18m, get_size(byol_tin_res18m)),
        (byol_tin_vt16_224, get_size(byol_tin_vt16_224)),

        (supce_cf10_res18m, get_size(supce_cf10_res18m)),
        (supce_cf10_vt16_224, get_size(supce_cf10_vt16_224)),
        (supce_cf100_res18m, get_size(supce_cf100_res18m)),
        (supce_cf100_vt16_224, get_size(supce_cf100_vt16_224)),
        (supce_in1k_res50, get_size(supce_in1k_res50)),
        (supce_in1k_vt16_224, get_size(supce_in1k_vt16_224)),
        (supce_tin_res18m, get_size(supce_tin_res18m)),
        (supce_tin_vt16_224, get_size(supce_tin_vt16_224)),
    ],
    
    'comb_tab4_cf10': [
        (supce_cf10_res18m, get_size(supce_cf10_res18m)),
        (supce_cf10_vt16_224, get_size(supce_cf10_vt16_224)),
        (mobilenet_v2, (224, 1000)),
        (resnet101, (224, 1000)),
    ],

    'comb_tab4_cf100': [
        (supce_cf100_res18m, get_size(supce_cf100_res18m)),
        (supce_cf100_vt16_224, get_size(supce_cf100_vt16_224)),
        (mobilenet_v2, (224, 1000)),
        (resnet101, (224, 1000)),
    ],

    'comb_tab4_tin': [
        (supce_tin_res18m, get_size(supce_tin_res18m)),
        (supce_tin_vt16_224, get_size(supce_tin_vt16_224)),
        (mobilenet_v2, (224, 1000)),
        (resnet101, (224, 1000)),
    ],

    'comb_test': [
        (random_test, (32, 512)),
        (supce_test, (32, 512)),
        
        (byol_test, (32, 512)),
    ],    
    'comb_1_client': [
        (byol_test, (32, 512)),
    ],
    'comb_df_size': [
        (byol_cf10_res18m, get_size(byol_cf10_res18m)),
        (supce_cf10_vt16_224, get_size(supce_cf10_vt16_224)),
        (random_in1k_res50, get_size(random_in1k_res50)),
    ],
    'comb_same': [
        (byol_test, (32, 512)),
        (byol_test, (32, 512)),
    ],
    'comb_cf10': [ 
        (random_test, (32, 512)),
        (supce_test, (32, 512)),
        (byol_test, (32, 512)),
        # (supce_cf10_res18m, get_size(supce_cf10_res18m)),
        # (byol_cf10_res18m, get_size(byol_cf10_res18m)),
        # (random_cf10_res18m, get_size(random_cf10_res18m)),
    ],
    'comb_cf100': [
        (random_cf100_res18m, get_size(random_cf100_res18m)),
        (byol_cf100_res18m, get_size(byol_cf100_res18m)),
        (supce_cf100_res18m, get_size(supce_cf100_res18m)),
    ],
    'comb_tin': [
        (byol_tin_res18m, get_size(byol_tin_res18m)),
        (supce_tin_res18m, get_size(supce_tin_res18m)),
        (random_tin_res18m, get_size(random_tin_res18m)),
    ],
    'comb_with_human': [
        (human, get_size(human)),
        # (random_test, (32, 512)),
        # (supce_test, (32, 512)),
    ]

}