select_method=$1
seed=$2
device_id=$3
epochs=$4
percentage=$5
eval_dir=$6
version=$7
model=$8
submodel=$9
save_dir=results_${version}_${eval_dir}_${model}/${select_method}_seed${seed}_epoch${epochs}_p${percentage}_${submodel}/bbh
mkdir -p $save_dir

if [ "$select_method" = "uniform" ] | [ "$select_method" = "barycenter" ] | [ "$select_method" = "rand" ]; then
    postfix=$select_method
else
    postfix="bbh"
fi

echo $postfix

if [ "$eval_dir" = "valid_data" ]; then
    max_num_examples_per_task=0
else
    max_num_examples_per_task=40
fi

echo max_num_examples_per_task

CUDA_VISIBLE_DEVICES=${device_id} python -m ${version}.bbh.run_eval \
    --data_dir ../data/${eval_dir}/bbh \
    --save_dir $save_dir \
    --model out/${model}-${select_method}-p${percentage}-lora-seed${seed}-${postfix}-epoch${epochs}/${submodel} \
    --tokenizer out/${model}-${select_method}-p${percentage}-lora-seed${seed}-${postfix}-epoch${epochs}/${submodel} \
    --eval_batch_size 5 \
    --convert_to_bf16 \
    --max_num_examples_per_task ${max_num_examples_per_task}
